using System;

public abstract class Shape
{
    private int xpos; 
    private int ypos;

    public abstract void draw();
	public abstract double area();
    
    public virtual void move(int x, int y)
    {
        xpos+=x;
        ypos+=y;
    }  
}

public class Square : Shape
{
    private int side;

    public Square(int s) {side=s;}

    public override void draw() { }

    public override double area() { return side*side; }
}

public class Circle : Shape
{
    private int radius;

    public Circle(int r) { radius = r; }

    public override void draw() { }

    public override double area() { return System.Math.PI*radius*radius; }
}


